#ifndef CALIBRATIONEEPROM_H
#define CALIBRATIONEEPROM_H

#ifdef _WIN32
#include <windows.h>
#else
#include "WinTypes.h"
#endif

#include "ftd2xxwrapper.h"
#include "er4commlib_errorcodes.h"
#include "stdint.h"

/*! EEPROM constants */
#define CEE_XCBUS_DIR 0x09 /*! Set high output pins: FPGA reset 0x01 + SPI program 0x08 */
#define CEE_SPI_PROG_ENABLE 0x00
#define CEE_SPI_PROG_DISABLE 0x08
#define CEE_FPGA_RESET_ENABLE 0x00
#define CEE_FPGA_RESET_DISABLE 0x01
#define CEE_WRITE_DONE 0x01
#define CEE_EEPROM_SIZE 2048

/*! Eeprom commands */
#define CEE_PROGRAM_CMD 0x02
#define CEE_READ_CMD 0x03
#define CEE_GET_STATUS_CMD 0x05
#define CEE_WRITE_ENABLE_CMD 0x06

#ifndef ER4COMMLIB_LABVIEW_WRAPPER
namespace er4CommLib {
#endif

class CalibrationEeprom {
public:
    CalibrationEeprom(uint32_t channel);

    ErrorCodes_t openConnection();
    ErrorCodes_t closeConnection();
    ErrorCodes_t enableFPGA(bool flag);
    ErrorCodes_t enableWrite();
    ErrorCodes_t writeBytes(unsigned char * values, unsigned int addr, unsigned int size);
    ErrorCodes_t pollWriteDone();
    ErrorCodes_t readBytes(unsigned char * values, unsigned int addr, unsigned int size);
    ErrorCodes_t readByte(unsigned char * value, unsigned int addr, bool start = true, bool end = true);
    ErrorCodes_t getStatus(unsigned char &eepromStatus);

    static unsigned int getMemorySize();

private:
    uint32_t channelIdx;
    ChannelConfig config;
    FT_HANDLE handle;
    bool connectionOpened = false;

    /*! Buffers */
    unsigned char writeBuffer[256];
    unsigned char readBuffer[256];
};

#ifndef ER4COMMLIB_LABVIEW_WRAPPER
};
#endif

#endif // CALIBRATIONEEPROM_H
